export const debounce = ( callback, delayMs ) => {
	let timeoutId = null;
	return ( ...args ) => {
		window.clearTimeout( timeoutId );
		timeoutId = window.setTimeout( () => {
			callback.apply( null, args );
		}, delayMs );
	};
};
