<?php
class SelectCoreElementorImageWithTitle extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_image_with_title'; 
	}

	public function get_title() {
		return esc_html__( 'Image With Title', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-image-with-title';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'image',
			[
				'label'     => esc_html__( 'Image', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'description' => esc_html__( 'Select images from media library', 'select-core' )
			]
		);

		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'Default', 'select-core'),
					'h1' => esc_html__( 'h1', 'select-core'),
					'h2' => esc_html__( 'h2', 'select-core'),
					'h3' => esc_html__( 'h3', 'select-core'),
					'h4' => esc_html__( 'h4', 'select-core'),
					'h5' => esc_html__( 'h5', 'select-core'),
					'h6' => esc_html__( 'h6', 'select-core')
				),
				'default' => 'h3',
				'condition' => [
					'title_text!' => ''
				]
			]
		);

		$this->add_control(
			'title_break_words',
			[
				'label'     => esc_html__( 'Position of Line Break', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter the position of the word after which you would like to create a line break (e.g. if you would like the line break after the 3rd word, you would enter &quot;3&quot;)', 'select-core' ),
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'link',
			[
				'label'     => esc_html__( 'Link', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter link for the image and title)', 'select-core' ),
				'condition' => [
					'title!' => ''
				]
			]
		);

		$this->add_control(
			'link_target',
			[
				'label'     => esc_html__( 'Link Target', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'_self' => esc_html__( 'Self', 'select-core'),
					'_blank' => esc_html__( 'Blank', 'select-core')
				),
				'default' => '_self',
				'condition' => [
					'link!' => ''
				]
			]
		);

		$this->add_control(
			'vertical_position',
			[
				'label'     => esc_html__( 'Title Vertical Position', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'top' => esc_html__( 'Top', 'select-core'),
					'middle' => esc_html__( 'Middle', 'select-core'),
					'bottom' => esc_html__( 'Bottom', 'select-core')
				),
				'default' => 'top'
			]
		);

		$this->add_control(
			'horizontal_position',
			[
				'label'     => esc_html__( 'Title Horizontal Position', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'left' => esc_html__( 'Left', 'select-core'),
					'right' => esc_html__( 'Right', 'select-core')
				),
				'default' => 'left'
			]
		);

		$this->add_control(
			'shadow',
			[
				'label'     => esc_html__( 'Enable Shadow', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		$params['image']          = !empty($params['image']) ? $params['image']['id'] : $params['image'];
		$params['title_tag']      = ! empty( $params['title_tag'] ) ? $params['title_tag'] : 'h3';
		$params['title']          = $this->getModifiedTitle( $params );
		$params['holder_classes'] = $this->getHolderClasses($params);

		echo qodef_core_get_shortcode_template_part('templates/image-with-title', 'image-with-title', '', $params);

	}

	private function getHolderClasses($params){
		$classes = array();

		$classes[] = ! empty($params['vertical_position']) ? 'qodef-iwt-vertical-'.$params['vertical_position'] : 'qodef-iwt-vertical-top';
		$classes[] = ! empty($params['horizontal_position']) ? 'qodef-iwt-'.$params['horizontal_position'] : 'qodef-iwt-left';

        if($params['shadow'] === 'yes') {
	        $classes[] = ' qodef-image-with-title-shadow';
        }

		return implode(' ', $classes);
	}

	private function getModifiedTitle( $params ) {
		$title             = $params['title'];
		$title_break_words = str_replace( ' ', '', $params['title_break_words'] );

		if ( ! empty( $title ) ) {
			$split_title = explode( ' ', $title );

			if ( ! empty( $title_break_words ) ) {
				$split_title[ $title_break_words - 1 ] = $split_title[ $title_break_words - 1 ] . '<br />';
			}

			$title = implode( ' ', $split_title );
		}

		return $title;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorImageWithTitle() );