<?php
class SelectCoreElementorCustomFont extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_custom_font'; 
	}

	public function get_title() {
		return esc_html__( 'Custom Font', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-custom-font';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'custom_font_tag',
			[
				'label'     => esc_html__( 'Custom Font Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'h2' => esc_html__( 'h2', 'select-core'),
					'h3' => esc_html__( 'h3', 'select-core'),
					'h4' => esc_html__( 'h4', 'select-core'),
					'h5' => esc_html__( 'h5', 'select-core'),
					'h6' => esc_html__( 'h6', 'select-core'),
					'p' => esc_html__( 'p', 'select-core'),
					'div' => esc_html__( 'div', 'select-core')
				),
				'default' => 'div'
			]
		);

		$this->add_control(
			'font_family',
			[
				'label'     => esc_html__( 'Font family', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'font_size',
			[
				'label'     => esc_html__( 'Font size (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'line_height',
			[
				'label'     => esc_html__( 'Line height (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'font_style',
			[
				'label'     => esc_html__( 'Font Style', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'normal' => esc_html__( 'normal', 'select-core'),
					'italic' => esc_html__( 'italic', 'select-core')
				),
				'default' => 'normal'
			]
		);

		$this->add_control(
			'font_weight',
			[
				'label'     => esc_html__( 'Font weight', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'100' => esc_html__( '100', 'select-core'),
					'200' => esc_html__( '200', 'select-core'),
					'300' => esc_html__( '300', 'select-core'),
					'400' => esc_html__( '400', 'select-core'),
					'500' => esc_html__( '500', 'select-core'),
					'600' => esc_html__( '600', 'select-core'),
					'700' => esc_html__( '700', 'select-core'),
					'800' => esc_html__( '800', 'select-core'),
					'900' => esc_html__( '900', 'select-core')
				),
				'default' => '100'
			]
		);

		$this->add_control(
			'letter_spacing',
			[
				'label'     => esc_html__( 'Letter Spacing (px/em)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'text_transform',
			[
				'label'     => esc_html__( 'Text transform', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'none' => esc_html__( 'None', 'select-core'),
					'capitalize' => esc_html__( 'Capitalize', 'select-core'),
					'uppercase' => esc_html__( 'Uppercase', 'select-core'),
					'lowercase' => esc_html__( 'Lowercase', 'select-core')
				),
				'default' => 'none'
			]
		);

		$this->add_control(
			'text_decoration',
			[
				'label'     => esc_html__( 'Text decoration', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( 'None', 'select-core'),
					'underline' => esc_html__( 'Underline', 'select-core'),
					'overline' => esc_html__( 'Overline', 'select-core'),
					'line-through' => esc_html__( 'Line Through', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'color',
			[
				'label'     => esc_html__( 'Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'text_align',
			[
				'label'     => esc_html__( 'Text Align', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'left' => esc_html__( 'Left', 'select-core'),
					'center' => esc_html__( 'Center', 'select-core'),
					'right' => esc_html__( 'Right', 'select-core'),
					'justify' => esc_html__( 'Justify', 'select-core')
				),
				'default' => ''
			]
		);

		$this->add_control(
			'content_custom_font',
			[
				'label'     => esc_html__( 'Content', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXTAREA
			]
		);

		$this->add_control(
			'type_out_effect',
			[
				'label'     => esc_html__( 'Enable Type Out Effect', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Adds a type out effect at the end of the custom font content.', 'select-core' ),
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'typed_ending_1',
			[
				'label'     => esc_html__( 'Typed Phrase 1', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'type_out_effect' => array( 'yes' )
				]
			]
		);

		$this->add_control(
			'typed_ending_2',
			[
				'label'     => esc_html__( 'Typed Phrase 2', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'typed_ending_1!' => ''
				]
			]
		);

		$this->add_control(
			'typed_ending_3',
			[
				'label'     => esc_html__( 'Typed Phrase 3', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'typed_ending_2!' => ''
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['custom_font_style']    = $this->getCustomFontStyle($params);
		$params['custom_font_tag']      = $this->getCustomFontTag($params);
		$params['custom_font_data']     = $this->getCustomFontData($params);

		//Get HTML from template
		echo qodef_core_get_shortcode_template_part('templates/custom-font-template', 'customfont', '', $params);

	}

	private function getCustomFontStyle($params) {
		$custom_font_style = array();

		if ($params['font_family'] !== '') {
			$custom_font_style[] = 'font-family: '.$params['font_family'];
		}

		if ($params['font_size'] !== '') {
			$font_size = strstr($params['font_size'], 'px') ? $params['font_size'] : $params['font_size'].'px';
			$custom_font_style[] = 'font-size: '.$font_size;
		}

		if ($params['line_height'] !== '') {
			$line_height = strstr($params['line_height'], 'px') ? $params['line_height'] : $params['line_height'].'px';
			$custom_font_style[] = 'line-height: '.$line_height;
		}

		if ($params['font_style'] !== '') {
			$custom_font_style[] = 'font-style: '.$params['font_style'];
		}

		if ($params['font_weight'] !== '') {
			$custom_font_style[] = 'font-weight: '.$params['font_weight'];
		}

		if ($params['letter_spacing'] !== '') {
			if (strstr($params['letter_spacing'], 'em')) {
				$letter_spacing = $params['letter_spacing'];
			} else {
				$letter_spacing = strstr($params['letter_spacing'], 'px') ? $params['letter_spacing'] : $params['letter_spacing'].'px';
			}
			
			$custom_font_style[] = 'letter-spacing: '.$letter_spacing;
		}

		if ($params['text_transform'] !== '') {
			$custom_font_style[] = 'text-transform: '.$params['text_transform'];
		}

		if ($params['text_decoration'] !== '') {
			$custom_font_style[] = 'text-decoration: '.$params['text_decoration'];
		}

		if ($params['text_align'] !== '') {
			$custom_font_style[] = 'text-align: '.$params['text_align'];
		}

		if ($params['color'] !== '') {
			$custom_font_style[] = 'color: '.$params['color'];
		}

		return implode(';', $custom_font_style);
	}

	private function getCustomFontTag($params) {
		$tag_array = array('h2', 'h3', 'h4', 'h5', 'h6','p','div');
		return (in_array($params['custom_font_tag'], $tag_array)) ? $params['custom_font_tag'] : 'div';
	}

	private function getCustomFontData($params) {
		$data_array = array();

		if ($params['font_size'] !== '') {
			$data_array[] = 'data-font-size= '.$params['font_size'];
		}

		if ($params['line_height'] !== '') {
			$data_array[] = 'data-line-height= '.$params['line_height'];
		}
		return implode(' ', $data_array);
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorCustomFont() );