<?php
class SelectCoreElementorCounter extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_counter'; 
	}

	public function get_title() {
		return esc_html__( 'Counter', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-counter';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'zero' => esc_html__( 'Zero Counter', 'select-core'),
					'random' => esc_html__( 'Random Counter', 'select-core')
				),
				'default' => 'zero'
			]
		);

		$this->add_control(
			'position',
			[
				'label'     => esc_html__( 'Position', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'left' => esc_html__( 'Left', 'select-core'),
					'right' => esc_html__( 'Right', 'select-core'),
					'center' => esc_html__( 'Center', 'select-core')
				),
				'default' => 'left'
			]
		);

		$this->add_control(
			'digit',
			[
				'label'     => esc_html__( 'Digit', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title',
			[
				'label'     => esc_html__( 'Title', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'     => esc_html__( 'Title Tag', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'h2' => esc_html__( 'h2', 'select-core'),
					'h3' => esc_html__( 'h3', 'select-core'),
					'h4' => esc_html__( 'h4', 'select-core'),
					'h5' => esc_html__( 'h5', 'select-core'),
					'h6' => esc_html__( 'h6', 'select-core')
				),
				'default' => 'h6'
			]
		);

		$this->add_control(
			'text',
			[
				'label'     => esc_html__( 'Text', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'border',
			[
				'label'     => esc_html__( 'Enable Right Border', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'design_options',
			[
				'label' => esc_html__( 'Design Options', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'font_size',
			[
				'label'     => esc_html__( 'Digit Font Size (px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);

		$this->add_control(
			'digit_color',
			[
				'label'     => esc_html__( 'Digit Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Title Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'text_color',
			[
				'label'     => esc_html__( 'Text Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR
			]
		);

		$this->add_control(
			'padding_bottom',
			[
				'label'     => esc_html__( 'Padding Bottom(px)', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		//get correct heading value. If provided heading isn't valid get the default one
		$headings_array                   = array('h2', 'h3', 'h4', 'h5', 'h6');
		$params['title_tag']              = (in_array($params['title_tag'], $headings_array)) ? $params['title_tag'] : 'h6';
		$params['counter_holder_classes'] = $this->getCounterHolderClasses($params);
		$params['counter_holder_styles']  = $this->getCounterHolderStyle($params);
		$params['counter_styles']         = $this->getCounterStyle($params);
		$params['title_styles']           = $this->getTitleStyle($params);
		$params['text_styles']            = $this->getTextStyle($params);

		//Get HTML from template
		echo qodef_core_get_shortcode_template_part('templates/counter-template', 'counter', '', $params);

	}

	private function getCounterHolderClasses($params) {
		$classes = array();

		$classes[] = 'qodef-counter-' . $params['position'];

		if ( $params['border'] === 'yes' ) {
			$classes[] = 'qodef-counter-with-border';
		}


		return implode(' ', $classes);
	}

	private function getCounterHolderStyle($params) {
		$counterHolderStyle = array();

		if ($params['padding_bottom'] !== '') {

			$counterHolderStyle[] = 'padding-bottom: ' . $params['padding_bottom'] . 'px';

		}

		return implode(';', $counterHolderStyle);
	}

	private function getCounterStyle($params) {
		$counterStyle = array();

		if ($params['font_size'] !== '') {
			$counterStyle[] = 'font-size: ' . $params['font_size'] . 'px';
		}
		if ($params['digit_color'] !== '') {
			$counterStyle[] = 'color: ' . $params['digit_color'];
		}

		return implode(';', $counterStyle);
	}

	private function getTextStyle($params) {
		$text_style = array();

		if ($params['text_color'] !== '') {
			$text_style[] = 'color: ' . $params['text_color'];
		}

		return implode(';', $text_style);
	}

	private function getTitleStyle($params) {
		$title_style = array();

		if ($params['title_color'] !== '') {
			$title_style[] = 'color: ' . $params['title_color'];
		}

		return implode(';', $title_style);
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorCounter() );