<?php
class SelectCoreElementorArtistsList extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_artists_list'; 
	}

	public function get_title() {
		return esc_html__( 'Artists List', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-artists-list';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'query_and_layout_options',
			[
				'label' => esc_html__( 'Query and Layout Options', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'order_by',
			[
				'label'     => esc_html__( 'Order By', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'name' => esc_html__( 'Name', 'select-core'),
					'artist_order' => esc_html__( 'Order Number', 'select-core')
				),
				'default' => 'name'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'select-core'),
					'DESC' => esc_html__( 'DESC', 'select-core')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'selected_artists',
			[
				'label'     => esc_html__( 'Show Only Artists with Listed IDs', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Delimit ID numbers by comma (leave empty for all)', 'select-core' )
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$artists = $this->getTaxonomyArray($params);
		$data_atts = $this->getDataAtts($params);

		?>
		<div class = "qodef-artists-list-holder-outer" <?php echo esc_attr($data_atts); ?>>
			<div class = "qodef-artists-list-holder clearfix" >
				<?php
					if(!empty($artists)) {
						foreach ($artists as $artist) {
							$params['artist'] = $artist;
							echo qodef_core_get_cpt_shortcode_template_part('albums', 'artist', '', $params);
						}
					} else { ?>
						<p><?php esc_html_e('Sorry, no artists matched your criteria.', 'select-core'); ?></p>
					<?php }
				?>
				<div class="qodef-artists-grid-sizer" ></div>
				<div class="qodef-artists-grid-gutter" ></div>
			</div>

			<div class="qodef-artist-single-expander"></div>
			<div class="qodef-artist-view-single">
				<?php
					if(!empty($artists) && is_array( $artists )) {
						$counter = 1;
						$params['number_of_artists'] = sprintf("%02d", count($artists));
						foreach ($artists as $artist) {
							$params['artist'] = $artist;
							$params['counter'] = sprintf("%02d", $counter);
							echo qodef_core_get_cpt_shortcode_template_part('albums', 'artist-single', '', $params);
							$counter++;
						}
						echo qodef_core_get_cpt_shortcode_template_part('albums', 'artist-single-navigation', '', $params);
					}
				?>

			</div>
		<?php wp_reset_postdata(); ?>
		</div>
	<?php
	}

	public function getTaxonomyArray($params){
		$tax = 'album-artist';

		$args = array(
			'hide_empty' => false,
			'order' => $params['order'],
		);

		if($params['order_by'] == 'artist_order'){
			$args['meta_key'] = 'artist_order';
			$args['orderby'] = 'meta_value';
		}else{
			$args['orderby'] = $params['order_by'];
		}

		if (!empty($params['selected_artists'])) {
			$args['include'] = $params['selected_artists'];
		}

		$artists = $terms = get_terms($tax, $args);

		return $artists;
	}

	public function getDataAtts($params){

		$data_attr = array();
		$data_return_string = '';

		if(!empty($params['order_by'])){
			$data_attr['data-order-by'] = $params['order_by'];
		}
		if(!empty($params['order'])){
			$data_attr['data-order'] = $params['order'];
		}

		if(!empty($params['selected_artists'])){
			$data_attr['data-selected-artists'] = $params['selected_artists'];
		}

		foreach($data_attr as $key => $value) {
			if($key !== '') {
				$data_return_string .= $key . '= "' . esc_attr( $value ) . '" ';
			}
		}
		return $data_return_string;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorArtistsList() );
