<?php
class SelectCoreElementorImageGallery extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_image_gallery'; 
	}

	public function get_title() {
		return esc_html__( 'Image Gallery', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-image-gallery';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'images',
			[
				'label'     => esc_html__( 'Images', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::GALLERY,
				'description' => esc_html__( 'Select images from media library', 'select-core' )
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'     => esc_html__( 'Image Size', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter image size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use &quot;thumbnail&quot; size', 'select-core' )
			]
		);

		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Gallery Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Select gallery type', 'select-core' ),
				'options' => array(
					'slider' => esc_html__( 'Slider', 'select-core'),
					'image_grid' => esc_html__( 'Image Grid', 'select-core'),
					'masonry' => esc_html__( 'Masonry', 'select-core')
				),
				'default' => 'slider'
			]
		);

		$this->add_control(
			'image_grid_space',
			[
				'label'     => esc_html__( 'With Space', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'no',
				'condition' => [
					'type' => array( 'image_grid' )
				]
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'     => esc_html__( 'Slide duration', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Auto rotate slides each X seconds', 'select-core' ),
				'options' => array(
					'3' => esc_html__( '3', 'select-core'),
					'5' => esc_html__( '5', 'select-core'),
					'10' => esc_html__( '10', 'select-core'),
					'disable' => esc_html__( 'Disable', 'select-core')
				),
				'default' => '5000',
				'condition' => [
					'type' => array( 'slider' )
				]
			]
		);

		$this->add_control(
			'slide_animation',
			[
				'label'     => esc_html__( 'Slide Animation', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'slide' => esc_html__( 'Slide', 'select-core'),
					'fade' => esc_html__( 'Fade', 'select-core')
				),
				'default' => 'slide',
				'condition' => [
					'type' => array( 'slider' )
				]
			]
		);

		$this->add_control(
			'column_number',
			[
				'label'     => esc_html__( 'Column Number', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'2' => esc_html__( '2', 'select-core'),
					'3' => esc_html__( '3', 'select-core'),
					'4' => esc_html__( '4', 'select-core'),
					'5' => esc_html__( '5', 'select-core')
				),
				'default' => '2',
				'condition' => [
					'type' => array( 'image_grid' )
				]
			]
		);

		$this->add_control(
			'pretty_photo',
			[
				'label'     => esc_html__( 'Open PrettyPhoto on click', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);

		$this->add_control(
			'grayscale',
			[
				'label'     => esc_html__( 'Grayscale Images', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no',
				'condition' => [
					'type' => array( 'image_grid' )
				]
			]
		);

		$this->add_control(
			'navigation',
			[
				'label'     => esc_html__( 'Show Navigation Arrows', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes',
				'condition' => [
					'type' => array( 'slider' )
				]
			]
		);

		$this->add_control(
			'pagination',
			[
				'label'     => esc_html__( 'Show Pagination', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes',
				'condition' => [
					'type' => array( 'slider' )
				]
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

		$params['slider_data'] = $this->getSliderData($params);
		$params['image_size'] = $this->getImageSize($params['image_size']);
		$params['images'] = $this->getGalleryImages($params);
		$params['pretty_photo'] = ($params['pretty_photo'] == 'yes') ? true : false;
		$params['columns'] = 'qodef-gallery-columns-' . $params['column_number'];
		$params['gallery_classes'] = ($params['grayscale'] == 'yes') ? 'qodef-grayscale' : '';
		$params['image_grid_space_classes'] = $this->getImageGridHolderClasses($params);

		if ($params['type'] == 'image_grid') {
			$template = 'gallery-grid';
		} elseif ($params['type'] == 'slider') {
			$template = 'gallery-slider';
		} elseif ($params['type'] == 'masonry') {
			$template = 'gallery-masonry';
		}

		echo qodef_core_get_shortcode_template_part('templates/' . $template, 'imagegallery', '', $params);

	}

	private function getGalleryImages($params) {
		$image_ids = array();
		$images = array();
		$i = 0;

		if ( $params['images'] !== '' ) {
			foreach ( $params['images'] as $image ) {
				$image_ids[] = $image['id'];
			}
		}

		foreach ($image_ids as $id) {

			$image['image_id'] = $id;
			$image['class'] = '';
			if ($params['type'] == 'masonry') {
		        $size = get_post_meta($id,'_qodef_masonry_image_size', true);
		        $size = ($size)?$size:'qodef-default-masonry-item';
		        switch($size){
			        case 'qodef-large-height-masonry-item' :
				        $img_size = 'mixtape_qodef_large_height';
				        $image['class'] = 'qodef-size-portrait';
				        break;
			        case 'qodef-large-width-masonry-item' :
				        $img_size = 'mixtape_qodef_large_width';
				        $image['class'] = 'qodef-size-landscape';
				        break;
			        case 'qodef-large-width-height-masonry-item' :
				        $img_size = 'mixtape_qodef_large_width_height';
				        $image['class'] = 'qodef-size-big-square';
				        break;
			        default:
				        $img_size = 'mixtape_qodef_square';
				        $image['class'] = 'qodef-size-square';
				        break;
		        }
			}
			else{
				$img_size = 'full';
			}
			$image_original = wp_get_attachment_image_src($id, $img_size);
			$image['masonry_size'] = $img_size;
			$image['url'] = $image_original[0];
			$image['title'] = get_the_title($id);

			$images[$i] = $image;
			$i++;
		}

		return $images;

	}

	private function getImageSize($image_size) {

		$image_size = trim($image_size);
		//Find digits
		preg_match_all( '/\d+/', $image_size, $matches );
		if(in_array( $image_size, array('thumbnail', 'thumb', 'medium', 'large', 'full'))) {
			return $image_size;
		} elseif(!empty($matches[0])) {
			return array(
					$matches[0][0],
					$matches[0][1]
			);
		} else {
			return 'thumbnail';
		}
	}

	private function getSliderData($params) {

		$slider_data = array();

		$slider_data['data-autoplay'] = ($params['autoplay'] !== '') ? $params['autoplay'] : '';
		$slider_data['data-animation'] = ($params['slide_animation'] !== '') ? $params['slide_animation'] : '';
		$slider_data['data-navigation'] = ($params['navigation'] !== '') ? $params['navigation'] : '';
		$slider_data['data-pagination'] = ($params['pagination'] !== '') ? $params['pagination'] : '';

		return $slider_data;

	}

	private function getImageGridHolderClasses($params){
		$imageGridClasses = '';

        if($params['image_grid_space'] == 'yes') {
            $imageGridClasses .= ' qodef-image-gallery-grid-with-space';
        }

		return $imageGridClasses;
		
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorImageGallery() );