<?php
namespace QodeCore\PostTypes\Events;

use QodeCore\Lib\PostTypeInterface;

/**
 * Class EventsRegister
 * @package QodeCore\PostTypes\Events
 */
class EventsRegister implements PostTypeInterface {
    /**
     * @var string
     */
    private $base;

    public function __construct() {
        $this->base		= 'event';
        $this->taxBase	= 'event-type';

        add_filter('single_template', array($this, 'registerSingleTemplate'));
    }

    /**
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Registers custom post type with WordPress
     */
    public function register() {
        $this->registerPostType();
        $this->registerTax();
    }


    /**
     * Registers event single template if one doesn't exists in theme.
     * Hooked to single_template filter
     * @param $single string current template
     * @return string string changed template
     */
    public function registerSingleTemplate($single) {
        global $post;

        if($post->post_type == $this->base) {
            if(!file_exists(get_template_directory().'/single-event.php')) {
                return QODE_CORE_CPT_PATH.'/events/templates/single-'.$this->base.'.php';
            }
        }

        return $single;
    }

    /**
     * Registers custom post type with WordPress
     */
    private function registerPostType() {
        global $mixtape_qodef_Framework, $mixtape_qodef_options;

        $menuPosition = 5;
        $menuIcon = 'dashicons-admin-post';
        $slug = $this->base;

        if(qodef_core_theme_installed()) {
            $menuPosition = $mixtape_qodef_Framework->getSkin()->getMenuItemPosition('event');
            $menuIcon = $mixtape_qodef_Framework->getSkin()->getMenuIcon('event');

            if(isset($mixtape_qodef_options['event_single_slug'])) {
                if($mixtape_qodef_options['event_single_slug'] != ""){
                    $slug = $mixtape_qodef_options['event_single_slug'];
                }
            }
        }

        register_post_type( $this->base,
            array(
                'labels'		=> array(
                    'name'			=> esc_html__( 'Events','select-core' ),
                    'singular_name'	=> esc_html__( 'Event','select-core' ),
                    'add_item'		=> esc_html__( 'New Event','select-core' ),
                    'add_new_item'	=> esc_html__( 'Add New Event','select-core' ),
                    'edit_item'		=> esc_html__( 'Edit Event','select-core' )
                ),
                'public'		=> true,
                'has_archive'	=> true,
                'rewrite'		=> array('slug' => $slug),
                'menu_position'	=> $menuPosition,
                'show_ui'		=> true,
                'supports'		=> array('author', 'title', 'editor', 'thumbnail', 'excerpt', 'page-attributes', 'comments'),
                'menu_icon'		=> $menuIcon
            )
        );
    }

    /**
     * Registers custom taxonomy with WordPress
     */
    private function registerTax() {
        $labels = array(
            'name'				=> esc_html__( 'Event Types', 'select-core' ),
            'singular_name'		=> esc_html__( 'Event Type', 'select-core' ),
            'search_items'		=> esc_html__( 'Search Event Types', 'select-core' ),
            'all_items'			=> esc_html__( 'All Event Types', 'select-core' ),
            'parent_item'		=> esc_html__( 'Parent Event Type', 'select-core' ),
            'parent_item_colon'	=> esc_html__( 'Parent Event Type:', 'select-core' ),
            'edit_item'			=> esc_html__( 'Edit Event Type', 'select-core' ),
            'update_item'		=> esc_html__( 'Update Event Type', 'select-core' ),
            'add_new_item'		=> esc_html__( 'Add New Event Type', 'select-core' ),
            'new_item_name'		=> esc_html__( 'New Event Type Name', 'select-core' ),
            'menu_name'			=> esc_html__( 'Event Types', 'select-core' ),
        );

        register_taxonomy($this->taxBase, array($this->base), array(
            'hierarchical'		=> true,
            'labels'			=> $labels,
            'show_ui'			=> true,
            'query_var'			=> true,
	        'show_admin_column'	=> true,
            'rewrite'			=> array( 'slug' => 'event-type' ),
        ));
    }
}
