<?php
class SelectCoreElementorAlbumsList extends \Elementor\Widget_Base {

	public $stores;

	public function __construct( $data = [], $args = null ) {
		parent::__construct( $data, $args );

		$this->stores = array(
			'itunes' => esc_html__('iTunes', 'select-core'),
			'google-play' => esc_html__('Google Play', 'select-core'),
			'bandcamp' => esc_html__('Bandcamp', 'select-core'),
			'spotify' => esc_html__('Spotify', 'select-core'),
			'amazonmp3' => esc_html__('AmazonMP3', 'select-core'),
			'deezer' => esc_html__('Deezer', 'select-core'),
		);
	}

	public function get_name() {
		return 'qodef_albums_list'; 
	}

	public function get_title() {
		return esc_html__( 'Albums List', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-albums-list';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Albums List Template', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'standard-with-space' => esc_html__( 'Standard With Space', 'select-core'),
					'gallery-with-space' => esc_html__( 'Gallery With Space', 'select-core'),
					'gallery-no-space' => esc_html__( 'Gallery No Space', 'select-core')
				),
				'default' => 'standard-with-space'
			]
		);

		$this->add_control(
			'show_stores',
			[
				'label'     => esc_html__( 'Show Stores', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'no',
				'condition' => [
					'type' => array( 'gallery-with-space' )
				]
			]
		);

		foreach ($this->stores as $store_key => $store) {
			$this->add_control(
				'stores_list_' . $store_key,
				[
					'label'     => esc_html__( 'Store To Be Shown ' . $store, 'select-core' ),
					'type'      => \Elementor\Controls_Manager::SWITCHER,
					'return_value' => 'yes',
					'default' => 'no',
					'condition' => [
						'show_stores' => array( 'yes' )
					]
				]
			);
		}



		$this->end_controls_section();

		$this->start_controls_section(
			'query_and_layout_options',
			[
				'label' => esc_html__( 'Query and Layout Options', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'order_by',
			[
				'label'     => esc_html__( 'Order By', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'date' => esc_html__( 'Date', 'select-core'),
					'title' => esc_html__( 'Title', 'select-core'),
					'menu_order' => esc_html__( 'Menu Order', 'select-core')
				),
				'default' => 'date'
			]
		);

		$this->add_control(
			'order',
			[
				'label'     => esc_html__( 'Order', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'ASC' => esc_html__( 'ASC', 'select-core'),
					'DESC' => esc_html__( 'DESC', 'select-core')
				),
				'default' => 'ASC'
			]
		);

		$this->add_control(
			'label',
			[
				'label'     => esc_html__( 'One-Label Albums List', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one label slug (leave empty for showing all labels)', 'select-core' )
			]
		);

		$this->add_control(
			'genre',
			[
				'label'     => esc_html__( 'One-Genre Albums List', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one genre slug (leave empty for showing all genres)', 'select-core' )
			]
		);

		$this->add_control(
			'artist',
			[
				'label'     => esc_html__( 'One-Artist Albums List', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter one artist slug (leave empty for showing all artists)', 'select-core' )
			]
		);

		$this->add_control(
			'number',
			[
				'label'     => esc_html__( 'Number of Albums Per Page', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( '(enter -1 to show all)', 'select-core' )
			]
		);

		$this->add_control(
			'columns',
			[
				'label'     => esc_html__( 'Number of Columns', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'description' => esc_html__( 'Default value is Three', 'select-core' ),
				'options' => array(
					'' => esc_html__( '', 'select-core'),
					'2' => esc_html__( 'Two', 'select-core'),
					'3' => esc_html__( 'Three', 'select-core'),
					'4' => esc_html__( 'Four', 'select-core')
				),
				'default' => '3'
			]
		);

		$this->add_control(
			'selected_albums',
			[
				'label'     => esc_html__( 'Show Only Albums with Listed IDs', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'Delimit ID numbers by comma (leave empty for all)', 'select-core' )
			]
		);

		$this->add_control(
			'show_load_more',
			[
				'label'     => esc_html__( 'Show Load More', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'no' => esc_html__( 'No', 'select-core'),
					'yes' => esc_html__( 'Yes', 'select-core')
				),
				'default' => 'no'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();
		$stores_list_array = array();

		foreach ($this->stores as $store_key => $store ){

			if( $params['stores_list_' . $store_key]  === 'yes' ) {
				$stores_list_array[] = $store_key;
			}

		}
		$params['stores_list'] = implode(',', $stores_list_array );

		$query_array = $this->getQueryArray($params);
		$query_results = new \WP_Query($query_array);
		$params['query_results'] = $query_results;

		$classes = $this->getAlbumsClasses($params);
		$data_atts = $this->getDataAtts($params);
		$data_atts .= 'data-max-num-pages = '.$query_results->max_num_pages;
		?>

		<div class = "qodef-albums-list-holder-outer <?php echo esc_attr($classes); ?>" <?php echo esc_attr($data_atts); ?>>
			<div class = "qodef-albums-list-holder clearfix" >
		
				<?php
					if($query_results->have_posts()):
						while ( $query_results->have_posts() ) : $query_results->the_post();

							$params['current_id'] = get_the_ID();
							$params['album_link'] = get_permalink($params['current_id']);
							$params['artist_html'] = $this->getAlbumArtistsHtml($params);

							if($params['type'] == 'standard-with-space' || $params['type'] == 'standard-no-space' ){
								echo qodef_core_get_cpt_shortcode_template_part('albums','standard', '', $params);
							} else {
								echo qodef_core_get_cpt_shortcode_template_part('albums','gallery', '', $params);
							}

						endwhile;
					else: ?>
						<p><?php esc_html_e( 'Sorry, no albums matched your criteria.', 'select-core'); ?></p>
					<?php endif; ?>
		</div>
			<?php
				if($params['show_load_more'] == 'yes'){
					 echo qodef_core_get_cpt_shortcode_template_part('albums','load-more-template', '', $params);
				}
				wp_reset_postdata(); ?>
		</div>
<?php
	}

	public function getQueryArray($params){

		$query_array = array(
		    'post_status' => 'publish',
			'post_type' => 'album',
			'orderby' =>$params['order_by'],
			'order' => $params['order'],
			'posts_per_page' => $params['number']
		);

		if(!empty($params['label'])){
			$query_array['album-label'] = $params['label'];
		}

		if(!empty($params['genre'])){
			$query_array['album-genre'] = $params['genre'];
		}

		if(!empty($params['artist'])){
			$query_array['album-artist'] = $params['artist'];
		}

		$albums_ids = null;
		if (!empty($params['selected_albums'])) {
			$albums_ids = explode(',', $params['selected_albums']);
			$query_array['post__in'] = $albums_ids;
		}

		if(!empty($params['next_page'])){
			$query_array['paged'] = $params['next_page'];

		}else{
			$query_array['paged'] = 1;
		}

		return $query_array;
	}

	public function getAlbumsClasses($params){
		$classes = array();
		$type = $params['type'];
		$columns = $params['columns'];
		switch($type):
			case 'standard-with-space':
			case 'standard-no-space':
				$classes[] = 'qodef-alb-standard';
				break;
			case 'gallery-with-space':
			case 'gallery-no-space':
				$classes[] = 'qodef-alb-gallery';
				break;
		endswitch;

	    
		switch ($columns):
			case '2':
				$classes[] = 'qodef-alb-two-columns';
				break;
			case '3':
				$classes[] = 'qodef-alb-three-columns';
				break;
			case '4':
				$classes[] = 'qodef-alb-four-columns';
				break;
		endswitch;

		if($type == 'standard-no-space' || $type == 'gallery-no-space' ){
			$classes[] = "qodef-album-wide";
		}

		if($params['show_load_more'] == 'yes') {
			$classes[] = "qodef-albums-load-more";
		}

		return implode(' ',$classes);

	}

	public function getDataAtts($params){

		$data_attr = array();
		$data_return_string = '';

		if(get_query_var('paged')) {
			$paged = get_query_var('paged');
		} elseif(get_query_var('page')) {
			$paged = get_query_var('page');
		} else {
			$paged = 1;
		}

		if(!empty($paged)) {
			$data_attr['data-next-page'] = $paged+1;
		}

		if(!empty($params['type'])){
			$data_attr['data-type'] = $params['type'];
		}
		if(!empty($params['columns'])){
			$data_attr['data-columns'] = $params['columns'];
		}
		if(!empty($params['order_by'])){
			$data_attr['data-order-by'] = $params['order_by'];
		}
		if(!empty($params['order'])){
			$data_attr['data-order'] = $params['order'];
		}
		if(!empty($params['number'])){
			$data_attr['data-number'] = $params['number'];
		}
		if(!empty($params['label'])){
			$data_attr['data-label'] = $params['label'];
		}
		if(!empty($params['genre'])){
			$data_attr['data-genre'] = $params['genre'];
		}
		if(!empty($params['artist'])){
			$data_attr['data-artist'] = $params['artist'];
		}
		if(!empty($params['selected_albums'])){
			$data_attr['data-selected-albums'] = $params['selected_albums'];
		}
        if(!empty($params['show_stores'])){
            $data_attr['data-show-stores'] = $params['show_stores'];
        }
        if(!empty($params['stores_list'])){
            $data_attr['data-stores-list'] = $params['stores_list'];
        }

		foreach($data_attr as $key => $value) {
			if($key !== '') {
				$data_return_string .= $key . '= "' . esc_attr( $value ) . '" ';
			}
		}
		return $data_return_string;
	}

	public function getAlbumArtistsHtml($params){
		$id = isset( $params['current_id'] ) ? $params['current_id'] : get_the_ID();

		$artists = wp_get_post_terms($id, 'album-artist');
		$artist_html = '<div class="qodef-alb-artists-holder">';
		$k = 1;
		if( is_array( $artists ) && count( $artists ) > 0 )
		foreach ($artists as $art) {
			$artist_html .= '<h5>'.$art->name.'</h5>';
			if (count($artists) != $k) {
				$artist_html .= ' / ';
			}
			$k++;
		}
		$artist_html .= '</div>';
		return $artist_html;
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorAlbumsList() );
