<?php
class SelectCoreElementorAlbumPlayer extends \Elementor\Widget_Base {

	public function get_name() {
		return 'qodef_album_player'; 
	}

	public function get_title() {
		return esc_html__( 'Album Player', 'select-core' );
	}

	public function get_icon() {
		return 'mixtape-elementor-custom-icon mixtape-elementor-album-player';
	}

	public function get_categories() {
		return [ 'select' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'general',
			[
				'label' => esc_html__( 'General', 'select-core' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'type',
			[
				'label'     => esc_html__( 'Type', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'standard' => esc_html__( 'Standard', 'select-core'),
					'compact' => esc_html__( 'Compact', 'select-core'),
					'simple' => esc_html__( 'Simple', 'select-core')
				),
				'default' => 'standard'
			]
		);

		$this->add_control(
			'album',
			[
				'label'     => esc_html__( 'Album', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array_flip($this->getAlbums()),
				'default' => ''
			]
		);

		$this->add_control(
			'full_width_bg',
			[
				'label'     => esc_html__( 'Content In Grid', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'yes' => esc_html__( 'Yes', 'select-core'),
					'no' => esc_html__( 'No', 'select-core')
				),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label'     => esc_html__( 'Player Background Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'skin' => array( 'light', 'dark' )
				]
			]
		);

		$this->add_control(
			'play_bg_color',
			[
				'label'     => esc_html__( 'Play Button Background Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'skin' => array( 'light', 'dark' )
				]
			]
		);

		$this->add_control(
			'nav_bg_color',
			[
				'label'     => esc_html__( 'Navigation Buttons Background Color', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'condition' => [
					'skin' => array( 'light', 'dark' )
				]
			]
		);

		$this->add_control(
			'skin',
			[
				'label'     => esc_html__( 'Skin', 'select-core' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'options' => array(
					'light' => esc_html__( 'Light', 'select-core'),
					'dark' => esc_html__( 'Dark', 'select-core'),
					'transparent' => esc_html__( 'Transparent', 'select-core')
				),
				'default' => 'light'
			]
		);


		$this->end_controls_section();
	}
	public function render() {

		$params = $this->get_settings_for_display();

        $params['player_styles'] = '';
        $params['play_button_styles'] = '';
        $params['nav_buttons_styles'] = '';
		if($params['skin'] == 'transparent'){
            $params['player_styles'] = $this->getPlayerStyles($params);
            $params['play_button_styles'] = $this->getPlayButtonStyles($params);
            $params['nav_buttons_styles'] = $this->getNavigationButtonsStyles($params);
        }

		$params['player_id'] = rand();
		$params['player_classes'] = $this->getPlayerClasses($params);

		echo qodef_core_get_cpt_shortcode_template_part('albums','album-player-'.$params['type'].'-template', '', $params);
	}

	private function getPlayerStyles($params) {

		$player_styles = array();

		if ($params['bg_color'] !== '') {
			$player_styles[] = 'background-color:' . $params['bg_color'];
		}

		return implode(';', $player_styles);
	}

	private function getPlayButtonStyles($params) {

		$play_button_styles = array();

		if ($params['play_bg_color'] !== '') {
			$play_button_styles[] = 'background-color:' . $params['play_bg_color'];
		}

		return implode(';', $play_button_styles);
	}

	private function getNavigationButtonsStyles($params) {

		$nav_buttons_styles = array();

		if ($params['nav_bg_color'] !== '') {
			$nav_buttons_styles[] = 'background-color:' . $params['nav_bg_color'];
		}

		return implode(';', $nav_buttons_styles);
	}

	private function getAlbums(){

		$albums_array = array();
		$args = array(
			'post_type' => 'album',
			'posts_per_page' => '-1'
		);

		$query = new \WP_Query($args);
		if($query->have_posts()) :
			while($query->have_posts()) : $query->the_post();
				$albums_array[get_the_ID()] = get_the_title();
			endwhile;
		endif;
		wp_reset_postdata();
		return  array_flip($albums_array);
	}

	private function getPlayerClasses($params) {

		$player_classes = array();
        $player_classes[] = 'qodef-player-'.$params['skin'];

		return implode(';', $player_classes);
	}

}
\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new SelectCoreElementorAlbumPlayer() );